using System;
using System.Collections.Generic;
using System.Linq;
using System.IO;
using System.Text;

public class Resenje
{
    private class Fenwick
    {
        private int n;
        private long[] tree;

        public Fenwick(int n)
        {
            this.n = n;
            tree = new long[n + 1];
        }

        public void Add(int i, long v)
        {
            while (i <= n)
            {
                tree[i] += v;
                i += i & -i;
            }
        }

        public long Sum(int i)
        {
            long s = 0;
            while (i > 0)
            {
                s += tree[i];
                i -= i & -i;
            }
            return s;
        }
    }

    private class FastScanner
    {
        private StreamReader reader;
        private string[] lineParts;
        private int pointer;

        public FastScanner(Stream stream)
        {
            reader = new StreamReader(stream);
            lineParts = new string[0];
            pointer = 0;
        }

        public string NextToken()
        {
            while (pointer >= lineParts.Length)
            {
                string line = reader.ReadLine();
                if (line == null) return null;
                lineParts = line.Split(new char[] { ' ', '\t' }, StringSplitOptions.RemoveEmptyEntries);
                pointer = 0;
            }
            return lineParts[pointer++];
        }

        public int NextInt()
        {
            return int.Parse(NextToken());
        }
    }

    public static void Main(string[] args)
    {
        FastScanner fs = new FastScanner(Console.OpenStandardInput());

        int N = fs.NextInt();
        int Q = fs.NextInt();

        int[] a = new int[N + 1];
        for (int i = 1; i <= N; i++)
        {
            a[i] = fs.NextInt();
        }

        List<SortedSet<int>> pos = new List<SortedSet<int>>(N + 1);
        for (int i = 0; i <= N; i++) pos.Add(new SortedSet<int>());

        for (int i = 1; i <= N; i++)
        {
            pos[a[i]].Add(i);
        }

        Fenwick fw = new Fenwick(N);

        Action<int> addValue = (v) =>
        {
            if (pos[v].Count > 0)
            {
                int last = pos[v].Max;
                fw.Add(last, 1L * v * pos[v].Count);
            }
        };

        Action<int> removeValue = (v) =>
        {
            if (pos[v].Count > 0)
            {
                int last = pos[v].Max;
                fw.Add(last, -1L * v * pos[v].Count);
            }
        };

        for (int v = 1; v <= N; v++)
        {
            addValue(v);
        }

        StringBuilder output = new StringBuilder();

        while (Q-- > 0)
        {
            int t = fs.NextInt();

            if (t == 1)
            {
                int k = fs.NextInt();
                output.Append(fw.Sum(k)).Append('\n');
            }
            else
            {
                int x = fs.NextInt();
                int y = fs.NextInt();

                int old = a[x];
                if (old != y)
                {
                    removeValue(old);
                    pos[old].Remove(x);
                    addValue(old);

                    removeValue(y);
                    pos[y].Add(x);
                    addValue(y);

                    a[x] = y;
                }
            }
        }

        Console.Write(output.ToString());
    }
}